unit CoreClassesUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Person = class;
  [UmlElement('Package', Id='7d58a156-0ba6-4c60-9cfe-1e4e1e11b859')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Person))]
  CoreClasses = class
  public
  type
    [UmlElement('Association', Id='ce14ccc5-932e-4c78-8c4b-9a156e6d4184')]
    Parenthood = class
    end;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]
  [UmlCollection(TypeOf(Person))]
  IPersonList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Person;
    procedure set_Item(index: Integer; Value: Person);
    property Item[index: Integer]: Person read get_Item write set_Item; default;
    function Add(value: Person): Integer;
    function Contains(value: Person): Boolean;
    function IndexOf(value: Person): Integer;
    procedure Insert(index: Integer; value: Person);
    procedure Remove(value: Person);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  [UmlElement(Id='3eb1d910-fcc9-4e2e-8999-a616ce0ae47c')]
  Person = class(System.Object, ILoopBack)
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Name = Eco_FirstMember;
    const
      Children = (Eco_LoopbackIndices.Name + 1);
    const
      Parents = (Eco_LoopbackIndices.Children + 1);
    end;

    PersonListAdapter = class(ObjectListAdapter, IPersonList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Person;
      procedure set_Item(index: Integer; Value: Person);
      property Item[index: Integer]: Person read get_Item write set_Item; default;
      function Add(value: Person): Integer;
      function Contains(value: Person): Boolean;
      function IndexOf(value: Person): Integer;
      procedure Insert(index: Integer; value: Person);
      procedure Remove(value: Person);
    end;
  protected
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
    {$REGION 'Autogenerated ECO code'}
  public
    constructor Create(content: IContent); overload;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    
    
    function get_Name: string;
    procedure set_Name(Value: string);
    [UmlElement(Id='690b9c07-3f57-4402-96be-465ee68e011c', Index=Eco_LoopbackIndices.Name)]
    property Name: string read get_Name write set_Name;
    
    
    
    function get_Children: IPersonList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Children, Id='5410849' +
    'b-3ff2-47fa-bdf5-6698128f3296')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Parenthood), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Children: IPersonList read get_Children;
    
    
    
    
    function get_Parents: IPersonList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Parents, Id='d98558b0' +
    '-f727-424b-aaeb-d54c9145c989')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Parenthood), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Parents: IPersonList read get_Parents;
    function AsIObject: IObjectInstance;
  strict protected
    eco_Content: IContent;
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

constructor Person.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

function Person.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Person.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Person.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

procedure Person.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;
{$ENDREGION}

constructor Person.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

constructor Person.PersonListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Person.PersonListAdapter.get_Item(index: Integer): Person;
begin
  Result := (Person(inherited Adaptee[index]));
end;

procedure Person.PersonListAdapter.set_Item(index: Integer; Value: Person);
begin
  inherited Adaptee[index] := value;
end;

function Person.PersonListAdapter.Add(value: Person): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Person.PersonListAdapter.Contains(value: Person): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Person.PersonListAdapter.IndexOf(value: Person): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Person.PersonListAdapter.Insert(index: Integer; value: Person);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Person.PersonListAdapter.Remove(value: Person);
begin
  Self.Adaptee.Remove(value);
end;

function Person.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Person.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

















function Person.get_Children: IPersonList;
begin
  Result := CoreClassesUnit.Person.PersonListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Children))));
end;





























function Person.get_Parents: IPersonList;
begin
  Result := CoreClassesUnit.Person.PersonListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Parents))));
end;



















































function Person.get_Name: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
end;

procedure Person.set_Name(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, (System.Object(Value)));
end;

{ CoreClasses }


























end.
